package com.java24hours;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

public class KeyViewer extends JFrame implements KeyListener {
    JTextField keyText = new JTextField(80);
    JLabel keyLabel = new JLabel("Wpisz jakikolwiek znak w polu tekstowym.");

    public KeyViewer() {
        super("Monitor klawiszy");
        setLookAndFeel();
        setSize(350, 100);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        keyText.addKeyListener(this);
        BorderLayout bord = new BorderLayout();
        setLayout(bord);
        add(keyLabel, BorderLayout.NORTH);
        add(keyText, BorderLayout.CENTER);
        setVisible(true);
    }

    @Override
    public void keyTyped(KeyEvent input) {
        char key = input.getKeyChar();
        keyLabel.setText("Wcisnąłeś " + key);
    }

    @Override
    public void keyPressed(KeyEvent txt) {
        // Nie rób nic
    }

    @Override
    public void keyReleased(KeyEvent txt) {
        // Nie rób nic
    }
    
    private void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(
                "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel"
            );
        } catch (Exception exc) {
            // Ignoruj błędy
        }
    }

    public static void main(String[] arguments) {
        KeyViewer frame = new KeyViewer();
    }
}
